/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant.dataticket;

import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class DataTicket<D> {
    static final Map<Pair<Type, String>, DataTicket<?>> IDENTITY_CACHE = new Object2ObjectOpenHashMap();
    private final String id;
    private final Class<? extends D> objectType;
    private final Type dataType;

    DataTicket(String id, Class<? extends D> objectType, Type dataType) {
        this.id = id;
        this.objectType = objectType;
        this.dataType = dataType;
    }

    public static <D> DataTicket<D> create(String id, Class<? extends D> objectType) {
        return DataTicket.create(id, objectType, TypeToken.of(objectType));
    }

    public static <D> DataTicket<D> create(String id, Class<? super D> objectType, TypeToken<D> token) {
        return IDENTITY_CACHE.computeIfAbsent((Pair<Type, String>)Pair.of((Object)token.getType(), (Object)id), pair -> new DataTicket(id, objectType, token.getType()));
    }

    public String id() {
        return this.id;
    }

    @Deprecated(forRemoval=true)
    public Class<? extends D> objectType() {
        return this.objectType;
    }

    public Type dataType() {
        return this.dataType;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.objectType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataTicket)) {
            return false;
        }
        DataTicket other = (DataTicket)obj;
        return this.objectType == other.objectType && this.id.equals(other.id);
    }

    public String toString() {
        return "DataTicket{" + this.id + ": " + this.objectType.getName() + "}";
    }
}

